/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.grid.GuiGrid;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import com.raoulvdberge.refinedstorage.gui.grid.view.GridViewImpl;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageGridItemUpdate
implements IMessage,
IMessageHandler<MessageGridItemUpdate, IMessage> {
    private boolean canCraft;
    private final List<IGridStack> stacks = new ArrayList<IGridStack>();
    private INetwork network;

    public MessageGridItemUpdate() {
    }

    public MessageGridItemUpdate(INetwork network, boolean canCraft) {
        this.network = network;
        this.canCraft = canCraft;
    }

    public void fromBytes(ByteBuf buf) {
        this.canCraft = buf.readBoolean();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.stacks.add(StackUtils.readItemGridStack(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.canCraft);
        int size = this.network.getItemStorageCache().getList().getStacks().size() + this.network.getItemStorageCache().getCraftablesList().getStacks().size();
        buf.writeInt(size);
        for (StackListEntry<ItemStack> stack : this.network.getItemStorageCache().getList().getStacks()) {
            StackListEntry<ItemStack> craftingEntry = this.network.getItemStorageCache().getCraftablesList().getEntry(stack.getStack(), 3);
            StackUtils.writeItemGridStack(buf, stack.getStack(), stack.getCount(), stack.getId(), craftingEntry != null ? craftingEntry.getId() : null, false, this.network.getItemStorageTracker().get(stack.getStack()));
        }
        for (StackListEntry<ItemStack> stack : this.network.getItemStorageCache().getCraftablesList().getStacks()) {
            StackListEntry<ItemStack> regularEntry = this.network.getItemStorageCache().getList().getEntry(stack.getStack(), 3);
            StackUtils.writeItemGridStack(buf, stack.getStack(), stack.getCount(), stack.getId(), regularEntry != null ? regularEntry.getId() : null, true, this.network.getItemStorageTracker().get(stack.getStack()));
        }
    }

    public IMessage onMessage(MessageGridItemUpdate message, MessageContext ctx) {
        GuiBase.executeLater(GuiGrid.class, grid -> {
            grid.setView(new GridViewImpl((GuiGrid)grid, GuiGrid.getDefaultSorter(), GuiGrid.getSorters()));
            grid.getView().setCanCraft(message.canCraft);
            grid.getView().setStacks(message.stacks);
            grid.getView().sort();
        });
        return null;
    }
}

